/*
 * Decompiled with CFR 0.152.
 */
package com.articles.web;

import com.articles.repo.domain.Article;
import com.articles.repo.domain.Comment;
import com.articles.service.ArticleService;
import com.articles.service.CommentService;
import com.articles.web.WebMapper;
import com.articles.web.dto.CommentForm;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class PagesController {
    private final ArticleService articleService;
    private final CommentService commentService;
    private final WebMapper webMapper;

    @GetMapping(value={"/"})
    public String index(Model m) {
        List chapters = this.articleService.findAllUniqueChapters();
        List popularArticles = this.articleService.getMostPopularArticles();
        List randomArticles = this.articleService.getRandomArticlesByChapters();
        m.addAttribute("chapters", (Object)chapters);
        m.addAttribute("randomArticles", (Object)this.webMapper.toArticleDtos(randomArticles));
        m.addAttribute("popularArticles", (Object)this.webMapper.toArticleDtos(popularArticles));
        return "index";
    }

    @GetMapping(value={"/articles/{article-id}"})
    public String articleById(Model m, @PathVariable(name="article-id") String articleId) {
        Article article = this.articleService.getById(articleId);
        m.addAttribute("chapters", (Object)this.articleService.findAllUniqueChapters());
        m.addAttribute("article", (Object)this.webMapper.toArticleDto(article));
        m.addAttribute("nextArticles", (Object)this.articleService.findNextRandomArticles(article));
        int random = new Random().nextInt(11);
        m.addAttribute("imageNumber", (Object)(random > 0 ? random : 1));
        return "article";
    }

    @GetMapping(value={"/articles/chapter/{chapter-name}"})
    public String articlesByChapter(Model m, @PathVariable(name="chapter-name") String chapterName) {
        List chapters = this.articleService.findAllUniqueChapters();
        List articles = this.articleService.findAllByChapterName(chapterName);
        m.addAttribute("articles", (Object)articles);
        m.addAttribute("chapters", (Object)chapters);
        m.addAttribute("chapter", (Object)((Article)articles.get(0)).getChapter());
        return "articles-by-chapter";
    }

    @PostMapping(value={"/comment"})
    public String addComment(CommentForm form, Model m) {
        Article article = this.articleService.getById(form.getArticleId());
        Comment comment = new Comment();
        comment.setAuthor(form.getAuthor());
        comment.setComment(form.getComment());
        comment.setDate(Instant.now());
        comment.setArticle(article);
        this.commentService.save(comment);
        List chapters = this.articleService.findAllUniqueChapters();
        m.addAttribute("chapters", (Object)chapters);
        m.addAttribute("article", (Object)this.articleService.getById(comment.getArticle().getId()));
        m.addAttribute("nextArticles", (Object)this.articleService.findNextRandomArticles(article));
        return "article";
    }

    public PagesController(ArticleService articleService, CommentService commentService, WebMapper webMapper) {
        this.articleService = articleService;
        this.commentService = commentService;
        this.webMapper = webMapper;
    }
}

